/*
 * Decompiled with CFR 0.152.
 */
package de.fhhannover.inform.trust.ifmapj.messages;

import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.MarshalException;
import de.fhhannover.inform.trust.ifmapj.exception.UnmarshalException;
import de.fhhannover.inform.trust.ifmapj.messages.Request;
import de.fhhannover.inform.trust.ifmapj.messages.RequestHandler;
import de.fhhannover.inform.trust.ifmapj.messages.Requests;
import de.fhhannover.inform.trust.ifmapj.messages.Result;
import de.fhhannover.inform.trust.ifmapj.messages.SearchHolder;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeDelete;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeElement;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeRequest;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeUpdate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DomHelpers;

class SubscribeRequestHandler
implements RequestHandler<SubscribeRequest> {
    SubscribeRequestHandler() {
    }

    @Override
    public Element toElement(Request req, Document doc) throws MarshalException {
        Requests.Helpers.checkRequestType(req, this);
        SubscribeRequest sr = (SubscribeRequest)req;
        Element ret = doc.createElementNS(Requests.Helpers.baseNsUri(), DomHelpers.makeRequestFQName("subscribe"));
        this.addSubscribeElements(sr, doc, ret);
        Requests.Helpers.addSessionId(ret, req);
        return ret;
    }

    private void addSubscribeElements(SubscribeRequest sr, Document doc, Element to) throws MarshalException {
        if (sr.getSubscribeElements().size() == 0) {
            throw new MarshalException("No subscribe elements");
        }
        for (SubscribeElement subEl : sr.getSubscribeElements()) {
            Element el;
            if (subEl.getName() == null) {
                throw new MarshalException("subscription name null");
            }
            if (subEl.getName().length() == 0) {
                throw new MarshalException("subscription name empty");
            }
            if (subEl instanceof SubscribeUpdate) {
                el = DomHelpers.createNonNsElement(doc, "update");
            } else if (subEl instanceof SubscribeDelete) {
                el = DomHelpers.createNonNsElement(doc, "delete");
            } else {
                throw new MarshalException("Unknown SubscribeElement implementation");
            }
            DomHelpers.addAttribute(el, "name", subEl.getName());
            if (subEl instanceof SearchHolder) {
                Requests.Helpers.addSearchInfo((SearchHolder)((Object)subEl), doc, el);
            }
            to.appendChild(el);
        }
    }

    @Override
    public Result fromElement(Element resp) throws UnmarshalException, IfmapErrorResult {
        Requests.Helpers.checkSimpleResult(resp, "subscribeReceived");
        return null;
    }

    @Override
    public Class<SubscribeRequest> handles() {
        return SubscribeRequest.class;
    }
}

