/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.config;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.FileInputStream;
import java.util.Properties;

public class GeneralPropertiesReader {
    private static final int POLLINGINTERVAL_DEFAULT = 10;
    private static final boolean RENEWSESSION_DEFAULT = false;
    private static final boolean ARCPOLLING_DEFAULT = false;
    private static final int RENEWSESSIONINTERVAL_DEFAULT = 30;
    private static final boolean BASICAUTHENABLED_DEFAULT = true;
    private static final boolean MESSAGING_SENDOLD = false;
    private static Properties sProps;
    private static boolean sFlag;
    private static String sPath;

    static {
        sFlag = false;
        sPath = "config/config.properties";
    }

    public static void setPath(String path) {
        sPath = path;
    }

    public static void loadProperties(String path) {
        sProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(path);
            sProps.load(in);
            in.close();
            GeneralPropertiesReader.initConfig(sProps);
            sFlag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("error while loading general properties from " + path);
        }
    }

    private static void initConfig(Properties conf) {
        if (!(GeneralPropertiesReader.initConfigFiles(conf) && GeneralPropertiesReader.initApplicationConfig(conf) && GeneralPropertiesReader.initMapServerConfig(conf))) {
            IfMapClient.exit("error while initializing configuration");
        }
    }

    private static boolean initConfigFiles(Properties conf) {
        GeneralConfig.POLLINGCONFIG_PATH = Toolbox.getStringProperty("application.pollingconfig.path", conf, true);
        if (GeneralConfig.POLLINGCONFIG_PATH == null) {
            return false;
        }
        GeneralConfig.MAPPINGCONFIG_PATH = Toolbox.getStringProperty("application.mappingconfig.path", conf, true);
        if (GeneralConfig.MAPPINGCONFIG_PATH == null) {
            return false;
        }
        GeneralConfig.POLLINGCONFIG_CLASSNAME = Toolbox.getStringProperty("application.pollingconfig.classname", conf, false);
        if (GeneralConfig.POLLINGCONFIG_CLASSNAME == null) {
            return false;
        }
        GeneralConfig.MAPPINGCONFIG_CLASSNAME = Toolbox.getStringProperty("application.mappingconfig.classname", conf, false);
        if (GeneralConfig.MAPPINGCONFIG_CLASSNAME == null) {
            return false;
        }
        GeneralConfig.REGEXCONFIG_PATH = Toolbox.getStringProperty("application.regexconfig.path", conf, false);
        return GeneralConfig.REGEXCONFIG_PATH != null;
    }

    private static boolean initApplicationConfig(Properties conf) {
        GeneralConfig.VERSION = Toolbox.getStringProperty("application.version", conf, false);
        GeneralConfig.POLLING_INTERVAL = Toolbox.getIntPropertyWithDefault("application.polling.interval", 10, conf, true);
        GeneralConfig.RENEWSESSION_ENABLED = Toolbox.getBoolPropertyWithDefault("application.renewsession.enabled", false, conf);
        GeneralConfig.ARCPOLLING_ENABLED = Toolbox.getBoolPropertyWithDefault("application.arcpolling.enabled", false, conf);
        GeneralConfig.MESSAGING_SENDOLD = Toolbox.getBoolPropertyWithDefault("application.messaging.sendold", false, conf);
        GeneralConfig.RENEWSESSION_INTERVALL = Toolbox.getIntPropertyWithDefault("application.renewsession.intervall", 30, conf, true);
        GeneralConfig.IPADDRESS = Toolbox.getStringPropertyWithDefault("application.ipaddress", conf, "");
        GeneralConfig.SNORT_MODE = Toolbox.getStringPropertyWithDefault("application.snort.mode", conf, "default");
        GeneralConfig.IPTABLES_MODE = Toolbox.getStringPropertyWithDefault("application.iptables.mode", conf, "default");
        GeneralConfig.IPTABLES_STARTSCRIPT = Toolbox.getStringPropertyWithDefault("application.iptables.startscript", conf, "config/iptables/intialize_rules.sh");
        GeneralConfig.IPTABLES_SENDDATASTREAMDETECTEDEVENT = Toolbox.getBoolPropertyWithDefault("application.iptables.senddatastreamevents", false, conf);
        GeneralConfig.IPTABLES_GATEWAYMODE = Toolbox.getBoolPropertyWithDefault("application.iptables.gateway", false, conf);
        GeneralConfig.MESSAGING_TYPE = Toolbox.getStringProperty("application.messaging.type", conf, false);
        if (GeneralConfig.MESSAGING_TYPE == null || !GeneralConfig.MESSAGING_TYPE.equalsIgnoreCase("update") && !GeneralConfig.MESSAGING_TYPE.equalsIgnoreCase("notify")) {
            return false;
        }
        SOAPMessageSender.publishMode = GeneralConfig.MESSAGING_TYPE.equalsIgnoreCase("update") ? (byte)0 : 1;
        return true;
    }

    private static boolean initMapServerConfig(Properties conf) {
        GeneralConfig.MAPSERVER_URL = Toolbox.getStringProperty("mapserver.url", conf, false);
        if (GeneralConfig.MAPSERVER_URL == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_KEYSTORE_PATH = Toolbox.getStringProperty("mapserver.keystore.path", conf, true);
        if (GeneralConfig.MAPSERVER_KEYSTORE_PATH == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD = Toolbox.getStringProperty("mapserver.keystore.password", conf, false);
        if (GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_TRUSTSTORE_PATH = Toolbox.getStringProperty("mapserver.truststore.path", conf, true);
        if (GeneralConfig.MAPSERVER_TRUSTSTORE_PATH == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD = Toolbox.getStringProperty("mapserver.truststore.password", conf, false);
        if (GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_BASICAUTH_ENABLED = Toolbox.getBoolPropertyWithDefault("mapserver.basicauth.enabled", true, conf);
        GeneralConfig.MAPSERVER_BASICAUTH_USER = Toolbox.getStringProperty("mapserver.basicauth.user", conf, false);
        if (GeneralConfig.MAPSERVER_BASICAUTH_USER == null) {
            return false;
        }
        GeneralConfig.MAPSERVER_BASICAUTH_PASSWORD = Toolbox.getStringProperty("mapserver.basicauth.password", conf, false);
        return GeneralConfig.MAPSERVER_BASICAUTH_PASSWORD != null;
    }

    public static String getProperty(String ident) {
        if (!sFlag) {
            GeneralPropertiesReader.loadProperties(sPath);
        }
        String value = sProps.getProperty(ident);
        return value;
    }
}

