/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.main;

import de.esukom.decoit.ifmapclient.config.BasicPropertiesReader;
import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.config.GeneralPropertiesReader;
import de.esukom.decoit.ifmapclient.iptables.IPTablesFacade;
import de.esukom.decoit.ifmapclient.logging.Logging;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.MappingResult;
import de.esukom.decoit.ifmapclient.messaging.IFMAPMessagingFacade;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import de.esukom.decoit.ifmapclient.pollingthreads.file.FilePollingThread;
import de.esukom.decoit.ifmapclient.pollingthreads.file.IPTablesULogFilePollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class IfMapClient
implements Observer {
    public static final Logger LOGGER = Logging.getTheLogger();
    public static String sMapServerIP = null;
    public static String sClientIP = null;
    private PollingThread mPollingThread;
    private final String mDefaultConfigPath = "config/config.properties";
    private Date lastLogRotateDate;

    public IfMapClient(String[] args) {
        this.init();
    }

    private void init() {
        this.initConfigFiles();
        Matcher ipMatcher = Toolbox.getRegExPattern("regex.ip4").matcher(GeneralConfig.MAPSERVER_URL);
        if (ipMatcher.find()) {
            sMapServerIP = ipMatcher.group();
        } else {
            IfMapClient.exit("error while parsing ip-address of map-server from general configuration");
        }
        sClientIP = GeneralConfig.IPADDRESS;
        if (!Toolbox.isNullOrEmpty(sClientIP)) {
            LOGGER.config("IP-Address for this Machine (as defined in config.properties) -> " + sClientIP);
        } else {
            IfMapClient.exit("no ip-address for this machine found in config.properties");
        }
        this.initMessagingFacade();
        this.lastLogRotateDate = Toolbox.getNowDate("yyyy-MM-dd");
        this.initPollingThreads();
        if (this.mPollingThread instanceof IPTablesULogFilePollingThread) {
            this.initIpTablesFacade();
            IPTablesFacade.getInstance().executeIPTableStartRules(IFMAPMessagingFacade.getInstance().mapServerIP);
        }
        this.initShutdownHook();
    }

    private void initConfigFiles() {
        if (new File("config/config.properties").exists()) {
            GeneralPropertiesReader.loadProperties("config/config.properties");
            BasicPropertiesReader.loadProperties(GeneralConfig.POLLINGCONFIG_PATH);
            BasicPropertiesReader.loadProperties(GeneralConfig.MAPPINGCONFIG_PATH);
            BasicPropertiesReader.loadProperties(GeneralConfig.REGEXCONFIG_PATH);
            Toolbox.loadAndPrepareRegExFromFile(BasicPropertiesReader.getProperties());
        } else {
            IfMapClient.exit("could not find main configuration file at: config/config.properties");
        }
    }

    private void initMessagingFacade() {
        IFMAPMessagingFacade.getInstance().init(sMapServerIP);
    }

    private void initIpTablesFacade() {
        BasicPropertiesReader.loadProperties("config/iptables/enforcement.properties");
        IPTablesFacade.getInstance().init(BasicPropertiesReader.getProperties());
    }

    private void initPollingThreads() {
        if (BasicPropertiesReader.getProperties() == null) {
            IfMapClient.exit("no properties found");
        }
        Class<?> pollingClass = null;
        try {
            pollingClass = Class.forName(GeneralConfig.POLLINGCONFIG_CLASSNAME);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            IfMapClient.exit("no valid polling-class found");
        }
        Constructor<?> constructor = null;
        try {
            constructor = pollingClass.getConstructor(Properties.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("could not get constructor for class " + GeneralConfig.POLLINGCONFIG_CLASSNAME);
        }
        try {
            this.mPollingThread = (PollingThread)constructor.newInstance(BasicPropertiesReader.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
            IfMapClient.exit("could not create new polling-class from " + GeneralConfig.POLLINGCONFIG_CLASSNAME);
        }
        this.mPollingThread.sleepTime = GeneralConfig.POLLING_INTERVAL * 1000;
        this.mPollingThread.addObserver(this);
    }

    private void initShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    IFMAPMessagingFacade.getInstance().sendEndSessionRequest();
                }
                catch (Exception e) {
                    IfMapClient.exit("error while initializing shutdown-hook!");
                }
            }
        });
    }

    public void start() {
        LOGGER.info("trying to connect to MAP-Server at: " + GeneralConfig.MAPSERVER_URL + "...");
        IFMAPMessagingFacade.getInstance().sendNewSessionRequest();
        IFMAPMessagingFacade.getInstance().sendPurgePublishRequest();
        LOGGER.info("connection established, publisher-id: " + IFMAPMessagingFacade.getInstance().getIFMAPPublisherId());
        if (this.mPollingThread != null) {
            this.mPollingThread.running = true;
            this.mPollingThread.pausing = false;
            new Thread(this.mPollingThread).start();
        } else {
            IfMapClient.exit("polling-thread could not be started");
        }
        if (GeneralConfig.POLLINGCONFIG_CLASSNAME.equals("de.esukom.decoit.ifmapclient.pollingthreads.IPTablesULogFilePollingThread") && GeneralConfig.ARCPOLLING_ENABLED && GeneralConfig.IPTABLES_MODE.equalsIgnoreCase("esukom")) {
            IFMAPMessagingFacade.getInstance().subscribeToAlertEvents();
        }
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        LOGGER.info("polling-thread notifies observer about new result!");
        if (o != null) {
            MappingFactory mappingFactory;
            ArrayList tmpResultList = (ArrayList)arg;
            if (tmpResultList != null && (mappingFactory = this.getMappingFactory(tmpResultList, GeneralConfig.MAPPINGCONFIG_CLASSNAME)) != null) {
                MappingResult[] resultList = mappingFactory.getMappingResult();
                if (resultList != null && resultList.length > 0) {
                    if (o instanceof IPTablesULogFilePollingThread) {
                        this.processIpTablesMappingResult(resultList);
                    } else {
                        IFMAPMessagingFacade.getInstance().sendPublishRequest(resultList);
                        LOGGER.info("done sending data to MAP-Server at " + GeneralConfig.MAPSERVER_URL);
                    }
                } else {
                    LOGGER.info("mapping result is null or empty, not sending anything to server");
                }
            }
        } else {
            LOGGER.info("result from " + GeneralConfig.POLLINGCONFIG_CLASSNAME + " is null, nothing to send to server");
        }
        if (!this.checkLogRotate(o)) {
            this.mPollingThread.pausing = false;
        }
    }

    private MappingFactory getMappingFactory(ArrayList<HashMap<String, String>> data, String mappingConfigClassName) {
        if (data != null) {
            Class<?> mappingClass = null;
            try {
                mappingClass = Class.forName(mappingConfigClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                IfMapClient.exit("could not find MappingClass-property in config.properties");
            }
            Constructor<?> constructor = null;
            try {
                constructor = mappingClass.getConstructor(Properties.class, ArrayList.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("could not get Constructor of MappingClass");
            }
            MappingFactory mappingFactory = null;
            try {
                mappingFactory = (MappingFactory)constructor.newInstance(BasicPropertiesReader.getProperties(), data);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("could not create MappingFactory");
            }
            return mappingFactory;
        }
        LOGGER.warning("could not create mapping factory from empty result");
        return null;
    }

    private void processIpTablesMappingResult(MappingResult[] resultList) {
        if (GeneralConfig.ARCPOLLING_ENABLED) {
            if (GeneralConfig.IPTABLES_MODE.equalsIgnoreCase("esukom")) {
                IFMAPMessagingFacade.getInstance().checkEntriesForAllowance(resultList);
            } else if (IFMAPMessagingFacade.getInstance().pollingClientList.addNewClientsToClientList(resultList)) {
                IFMAPMessagingFacade.getInstance().updateSubscribtions();
                if (GeneralConfig.IPTABLES_SENDDATASTREAMDETECTEDEVENT) {
                    IFMAPMessagingFacade.getInstance().sendPublishRequest(resultList);
                }
            }
        }
    }

    private boolean checkLogRotate(Observable o) {
        Date currentDate;
        FilePollingThread fpt;
        if (o instanceof FilePollingThread && (fpt = (FilePollingThread)o).isLogRotateActive() && (currentDate = Toolbox.getNowDate("yyyy-MM-dd")).after(this.lastLogRotateDate)) {
            this.lastLogRotateDate = currentDate;
            this.mPollingThread = null;
            this.initPollingThreads();
            this.mPollingThread.running = true;
            this.mPollingThread.pausing = false;
            new Thread(this.mPollingThread).start();
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        IfMapClient client = new IfMapClient(args);
        client.start();
    }

    public static void exit(String errorMsg) {
        if (errorMsg != null) {
            LOGGER.severe("client ended due to error with message: " + errorMsg);
            System.exit(1);
        } else {
            LOGGER.info("client ended normaly...bye bye :-)");
            System.exit(0);
        }
    }
}

