/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.MappingFactory;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import de.fhhannover.inform.trust.ifmapj.metadata.Significance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class SimpleEventMappingFactory
extends MappingFactory {
    public static final String MAPPINGKEYS_EVENTTYPE = "eventmapping.eventtype";
    public static final String MAPPINGKEYS_MAGNITUDE = "eventmapping.magnitude";
    public static final String MAPPINGKEYS_CONFIDENCE = "eventmapping.confidence";
    public static final String MAPPINGKEYS_SIGNIFICANCE = "eventmapping.significance";
    public static final String MAPPINGVALUES_EVENTTYPE_CHANGE = "behavioral-change";
    public static final String MAPPINGVALUES_EVENTTYPE_BOTNET = "botnet-infection";
    public static final String MAPPINGVALUES_EVENTTYPE_CVE = "cve";
    public static final String MAPPINGVALUES_EVENTTYPE_FLOW = "excessive-flows";
    public static final String MAPPINGVALUES_EVENTTYPE_OTHER = "other";
    public static final String MAPPINGVALUES_EVENTTYPE_P2P = "p2p";
    public static final String MAPPINGVALUES_EVENTTYPE_POLICY = "policy-violation";
    public static final String MAPPINGVALUES_EVENTTYPE_WORM = "worm-infection";
    public static final String MAPPINGVALUES_SIGNIFICANCE_INFO = "informational";
    public static final String MAPPINGVALUES_SIGNIFICANCE_IMPORTANT = "important";
    public static final String MAPPINGVALUES_SIGNIFICANCE_CRITICAL = "critical";
    protected EventType mEventtypeDefault;
    protected String mMagnitudeDefault;
    protected String mConfidenceDefault;
    protected Significance mSignificanceDefault;

    public SimpleEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void initProperties(Properties props) {
        this.mEventtypeDefault = this.getEventTypeFromProperties(props);
        if (this.mEventtypeDefault == null) {
            IfMapClient.exit("could not load eventmapping.eventtype from mapping.properties");
        }
        this.mSignificanceDefault = this.getSignificanceFromProperties(props);
        if (this.mSignificanceDefault == null) {
            IfMapClient.exit("could not load eventmapping.significance from mapping.properties");
        }
        this.mMagnitudeDefault = this.getNummericValueFromPropertiesAsString(MAPPINGKEYS_MAGNITUDE, props);
        if (this.mMagnitudeDefault == null) {
            IfMapClient.exit("could not load eventmapping.magnitude from mapping.properties");
        }
        this.mConfidenceDefault = this.getNummericValueFromPropertiesAsString(MAPPINGKEYS_CONFIDENCE, props);
        if (this.mConfidenceDefault == null) {
            IfMapClient.exit("could not load eventmapping.confidencefrom mapping.properties");
        }
    }

    private EventType getEventTypeFromProperties(Properties props) {
        String eventTypeFromConfig = Toolbox.getStringProperty(MAPPINGKEYS_EVENTTYPE, props, false);
        if (Toolbox.isNullOrEmpty(eventTypeFromConfig)) {
            return null;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_BOTNET)) {
            return EventType.botnetInfection;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_CVE)) {
            return EventType.cve;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_FLOW)) {
            return EventType.excessiveFlows;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_OTHER)) {
            return EventType.other;
        }
        if (eventTypeFromConfig.equals(MAPPINGVALUES_EVENTTYPE_P2P)) {
            return EventType.p2p;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_POLICY)) {
            return EventType.policyViolation;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_WORM)) {
            return EventType.wormInfection;
        }
        if (eventTypeFromConfig.equalsIgnoreCase(MAPPINGVALUES_EVENTTYPE_CHANGE)) {
            return EventType.behavioralChange;
        }
        return null;
    }

    private Significance getSignificanceFromProperties(Properties props) {
        String significance = Toolbox.getStringProperty(MAPPINGKEYS_SIGNIFICANCE, props, false);
        if (Toolbox.isNullOrEmpty(significance)) {
            return null;
        }
        if (significance.equalsIgnoreCase(MAPPINGVALUES_SIGNIFICANCE_IMPORTANT)) {
            return Significance.important;
        }
        if (significance.equalsIgnoreCase(MAPPINGVALUES_SIGNIFICANCE_CRITICAL)) {
            return Significance.critical;
        }
        if (significance.equalsIgnoreCase(MAPPINGVALUES_SIGNIFICANCE_INFO)) {
            return Significance.informational;
        }
        return null;
    }

    private String getNummericValueFromPropertiesAsString(String mappingKey, Properties props) {
        String returnValue = null;
        try {
            return String.valueOf(new Integer(Toolbox.getStringProperty(mappingKey, props, false)));
        }
        catch (NumberFormatException nfe) {
            IfMapClient.exit("could not load value from mapping.properties for " + mappingKey);
            return returnValue;
        }
    }
}

