/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory.impl;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.SimpleEventMappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class IPTablesEventMappingFactory
extends SimpleEventMappingFactory {
    private int mDuplicateEntriesDelay;

    public IPTablesEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void initProperties(Properties props) {
        super.initProperties(props);
        this.mDuplicateEntriesDelay = Toolbox.getIntPropertyWithDefault("iptables.eventmapping.timedelay", 0, props, false);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        boolean isFirstEntry = true;
        String prevDiscTime = null;
        for (HashMap<String, String> hashMap : res) {
            String discTime = null;
            EventMappingResult event = new EventMappingResult();
            Matcher timestampMatcher = Toolbox.getRegExPattern("regex.ifmaptimestamp").matcher(hashMap.get("0"));
            if (timestampMatcher == null || !timestampMatcher.find()) {
                IfMapClient.LOGGER.warning("could not find timestamp for current entry, skipping entry");
                continue;
            }
            discTime = timestampMatcher.group();
            String dstIp = null;
            Matcher srcMatcher = Toolbox.getRegExPattern("regex.ip4.src").matcher(hashMap.get("0"));
            if (srcMatcher == null || !srcMatcher.find()) {
                IfMapClient.LOGGER.warning("could not find src ip for current entry, skipping entry");
                continue;
            }
            String srcIp = srcMatcher.group().replace("SRC=", "");
            event.setIp(srcIp);
            Matcher dstMatcher = Toolbox.getRegExPattern("regex.ip4.dst").matcher(hashMap.get("0"));
            if (dstMatcher != null && dstMatcher.find()) {
                dstIp = dstMatcher.group().replace("DST=", "");
            } else {
                IfMapClient.LOGGER.warning("could not find dst ip for current entry, skipping entry");
            }
            if (srcIp.equals(IfMapClient.sMapServerIP) & dstIp.equals(IfMapClient.sClientIP) || srcIp.equals(IfMapClient.sClientIP) & dstIp.equals(IfMapClient.sMapServerIP)) continue;
            event.setName("datastream detected from " + srcIp + " to " + dstIp);
            boolean insertEntry = false;
            if (!isFirstEntry) {
                int j = 0;
                while (j < this.mapResult.size()) {
                    EventMappingResult tempEvent = (EventMappingResult)this.mapResult.get(j);
                    if (tempEvent.getName().equals(event.getName()) & tempEvent.getIp().equals(event.getIp())) {
                        Calendar prevCalendar = Toolbox.getCalendarFromString(prevDiscTime, "yyyy-MM-dd HH:mm:ss", null);
                        prevCalendar.add(13, this.mDuplicateEntriesDelay * -1);
                        if (Toolbox.getCalendarFromString(discTime, "yyyy-MM-dd HH:mm:ss", null).after(prevCalendar)) {
                            this.mapResult.remove(j);
                            insertEntry = true;
                        } else {
                            prevDiscTime = discTime;
                        }
                    } else {
                        insertEntry = true;
                    }
                    ++j;
                }
            } else {
                isFirstEntry = false;
                insertEntry = true;
            }
            if (!insertEntry) continue;
            event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
            event.setSignificance(this.mSignificanceDefault);
            event.setEventMessageType(this.mEventtypeDefault);
            event.setConfidence(this.mConfidenceDefault);
            event.setMagnitude(this.mMagnitudeDefault);
            event.setIpType("IPv4");
            prevDiscTime = discTime;
            event.setDiscoveredTime(Toolbox.convertTimestampToIfMapFormat(discTime, "-", " "));
            this.mapResult.add(event);
            IfMapClient.LOGGER.fine("iptables event has been added to result: " + event.showOnConsole());
        }
    }
}

