/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory.impl;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.SimpleEventMappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class NagiosEventMappingFactory
extends SimpleEventMappingFactory {
    private final String mTimestampKey = "timestamp";
    private final String mAddressKey = "address";
    private final String mEventsourceKey = "source";
    private final String mEventstateKey = "state";

    public NagiosEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {
        String missingValue = null;
        EventMappingResult event = new EventMappingResult();
        for (HashMap<String, String> hashMap : data) {
            if (hashMap.get("timestamp") == null) {
                missingValue = "event.discovered_time";
                break;
            }
            event.setDiscoveredTime(Toolbox.convertTimestampToIfMapFormat(hashMap.get("timestamp"), "/", "-"));
            if (hashMap.get("address") == null) {
                missingValue = "event.ip";
                break;
            }
            event.setIp(hashMap.get("address"));
            if (hashMap.get("source") == null || hashMap.get("state") == null) {
                missingValue = "event.name";
                break;
            }
            String eventName = null;
            eventName = hashMap.get("source").startsWith("host") ? "Detected Host State: " + hashMap.get("state") : (hashMap.get("source").startsWith("service") ? "Detected Service State: " + hashMap.get("state") : "Undefined Event Name");
            event.setName(eventName);
            event.setIpType("IPv4");
            event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
            event.setSignificance(this.mSignificanceDefault);
            event.setEventMessageType(this.mEventtypeDefault);
            event.setConfidence(this.mConfidenceDefault);
            event.setMagnitude(this.mMagnitudeDefault);
        }
        if (missingValue == null) {
            this.mapResult.add(event);
        } else {
            IfMapClient.LOGGER.warning("mapping of nagios-event failed - cannot find values" + missingValue);
            this.mapResult = null;
        }
    }
}

