/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory.impl;

import de.esukom.decoit.ifmapclient.mappingfactory.SimpleEventMappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.result.MappingResult;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;

public class RadiusEventMappingFactory
extends SimpleEventMappingFactory {
    public RadiusEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> data) {
        SimpleDateFormat ifmapTimeStyle = new SimpleDateFormat("yyyy-MM-dd'T'kk:mm:ss'Z'");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.ENGLISH);
        SimpleDateFormat dateFormat2 = new SimpleDateFormat(Toolbox.getNowDateAsString("yyyy-MM-dd HH:mm:ss"));
        int i = 0;
        while (i < data.size()) {
            HashMap<String, String> temp = data.get(i);
            int j = 1;
            while (j <= temp.size()) {
                if (temp.get(String.valueOf(j)) != null) {
                    Calendar date = null;
                    Matcher dateMatcher = Toolbox.getRegExPattern("regex.date").matcher(temp.get(String.valueOf(j)));
                    Date datum = null;
                    if (dateMatcher.find()) {
                        try {
                            datum = dateFormat.parse(dateMatcher.group());
                            date = Toolbox.getCalendarFromString(dateFormat2.format(datum), "yyyy-MM-dd HH:mm:ss", null);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        Calendar calender = Toolbox.getCalendarFromString(Toolbox.sClientStartTime, "yyyy-MM-dd HH:mm:ss", null);
                        if (date.compareTo(calender) >= 0) {
                            Matcher typeMatcher;
                            Matcher ipMatcher;
                            EventMappingResult event = new EventMappingResult();
                            event.setDiscoveredTime(ifmapTimeStyle.format(datum));
                            Matcher user_pw = Toolbox.getRegExPattern("regex.pwdefault").matcher(temp.get(String.valueOf(j)));
                            if (user_pw.find()) {
                                event.setIdentity(user_pw.group());
                            }
                            if ((user_pw = Toolbox.getRegExPattern("regex.userdetail").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setIdentity(user_pw.group().replace("User-Name = ", "").replace(",", ""));
                            }
                            if ((ipMatcher = Toolbox.getRegExPattern("regex.ip4").matcher(temp.get(String.valueOf(j)).replace("localhost", "127.0.0.1"))).find()) {
                                event.setIp(ipMatcher.group());
                                event.setIpType("IPv4");
                            }
                            if ((typeMatcher = Toolbox.getRegExPattern("regex.defaultlogin").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setName(typeMatcher.group());
                            }
                            if ((typeMatcher = Toolbox.getRegExPattern("regex.acctstatus").matcher(temp.get(String.valueOf(j)))).find()) {
                                event.setName(typeMatcher.group());
                            } else {
                                event.setName("Acct");
                            }
                            event.setConfidence(this.mConfidenceDefault);
                            event.setMagnitude(this.mMagnitudeDefault);
                            event.setSignificance(this.mSignificanceDefault);
                            event.setEventMessageType(this.mEventtypeDefault);
                            this.mapResult.add(event);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.mapResult.size()) {
            System.out.println(((MappingResult)this.mapResult.get(i)).showOnConsole());
            ++i;
        }
    }
}

