/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory.impl;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.SnortEventMappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import de.fhhannover.inform.trust.ifmapj.metadata.EventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class SnortFileEventMappingFactory
extends SnortEventMappingFactory {
    private final String mLineName = "0";
    private final String mLineClass = "1";
    private final String mLinePrio = "1";
    private final String mLineDiscTime = "2";
    private final String mLineIp = "2";
    private final String mLineVulUri = "5";
    private final boolean mSkipIP6 = true;

    public SnortFileEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        for (HashMap<String, String> hashMap : res) {
            Matcher vulnaribilityMatcher;
            EventType msgType = null;
            String discTime = null;
            Matcher classMatcher = Toolbox.getRegExPattern("regex.class").matcher(hashMap.get("1"));
            if (classMatcher.find()) {
                msgType = this.getEventMappingForSignatureName(classMatcher.group().replace("Classification: ", ""));
            } else {
                msgType = EventType.other;
                IfMapClient.LOGGER.warning("could not find classification for entry...using default (other)");
            }
            Matcher timestampMatcher = Toolbox.getRegExPattern("regex.timestamp").matcher(hashMap.get("2"));
            if (timestampMatcher.find()) {
                discTime = String.valueOf(Toolbox.getNowDateAsString("yyyy")) + "/" + timestampMatcher.group();
                if (!GeneralConfig.MESSAGING_SENDOLD && !Toolbox.getCalendarFromString(discTime, "yyyy/MM/dd-HH:mm:ss", null).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime, "yyyy-MM-dd HH:mm:ss", null))) {
                    discTime = null;
                }
            } else {
                IfMapClient.LOGGER.warning("could not find timestamp for entry...skipping entry!");
            }
            if (msgType == null || discTime == null || !this.doConvert(msgType)) continue;
            EventMappingResult event = new EventMappingResult();
            event.setEventMessageType(msgType);
            event.setDiscoveredTime(Toolbox.convertTimestampToIfMapFormat(discTime, "/", "-"));
            Matcher ipMatcher = Toolbox.getRegExPattern("regex.ip4").matcher(hashMap.get("2"));
            if (ipMatcher.find()) {
                event.setIp(ipMatcher.group());
                event.setIpType("IPv4");
            }
            if (event.getIp() == null) continue;
            Matcher typeMatcher = Toolbox.getRegExPattern("regex.type").matcher(hashMap.get("0"));
            if (typeMatcher.find()) {
                event.setName(typeMatcher.group().replace("] ", "").replace(" [", ""));
            } else {
                IfMapClient.LOGGER.warning("could not find event name for entry");
            }
            Matcher priorityMatcher = Toolbox.getRegExPattern("regex.priority").matcher(hashMap.get("1"));
            if (priorityMatcher.find()) {
                event.setSignificance(this.getSignificanceValue(new Integer(priorityMatcher.group().replace("Priority: ", ""))));
            } else {
                IfMapClient.LOGGER.warning("could not find priority for entry");
            }
            if (hashMap.get("5") != null && (vulnaribilityMatcher = Toolbox.getRegExPattern("regex.vulnaribilityuri").matcher(hashMap.get("5"))).find()) {
                event.setVulnerabilityUri(vulnaribilityMatcher.group().replace("[Xref => ", "").replace("]h", " ; h").replace("]", ""));
                event.setVulnerabilityUri("http://cve.mitre.org/cgi-bin/cvename.cgi?name=2005-0068");
            }
            event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
            event.setConfidence("100");
            event.setMagnitude("45");
            this.mapResult.add(event);
            IfMapClient.LOGGER.fine("mapped snort event has been added to result list: " + event.showOnConsole());
        }
    }
}

