/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.mappingfactory.impl;

import de.esukom.decoit.ifmapclient.mappingfactory.SimpleEventMappingFactory;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.messaging.SOAPMessageSender;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class TNCEventMappingFactory
extends SimpleEventMappingFactory {
    public TNCEventMappingFactory(Properties props, ArrayList<HashMap<String, String>> data) {
        super(props, data);
    }

    @Override
    protected void createMappingResult(Properties props, ArrayList<HashMap<String, String>> res) {
        for (HashMap<String, String> hashMap : res) {
            EventMappingResult event = new EventMappingResult();
            String currentDate = Toolbox.getNowDateAsString("yyyy-MM-dd");
            Matcher timestampMatcher = Toolbox.getRegExPattern("regex.timestamp").matcher(hashMap.get("0"));
            Matcher allowOrDenyMatcher = Toolbox.getRegExPattern("regex.allowdeny").matcher(hashMap.get("0"));
            Matcher ipMatcher = Toolbox.getRegExPattern("regex.ip4").matcher(hashMap.get("0"));
            if (timestampMatcher == null || !timestampMatcher.find() || allowOrDenyMatcher == null || !allowOrDenyMatcher.find() || ipMatcher == null || !ipMatcher.find()) continue;
            event.setDiscoveredTime(String.valueOf(currentDate) + "T" + timestampMatcher.group() + "Z");
            event.setName("TNC-Server " + allowOrDenyMatcher.group() + " access for IP " + ipMatcher.group());
            event.setDiscovererId(SOAPMessageSender.getInstance().getIfMapPublisherId());
            event.setIp(ipMatcher.group());
            event.setSignificance(this.mSignificanceDefault);
            event.setEventMessageType(this.mEventtypeDefault);
            event.setConfidence(this.mConfidenceDefault);
            event.setMagnitude(this.mMagnitudeDefault);
            event.setIpType("IPv4");
            this.mapResult.add(event);
        }
    }
}

