/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.messaging;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.mappingfactory.result.EventMappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.result.MappingResult;
import de.esukom.decoit.ifmapclient.mappingfactory.result.OpenVPNMappingResult;
import de.fhhannover.inform.trust.ifmapj.IfmapJ;
import de.fhhannover.inform.trust.ifmapj.IfmapJHelper;
import de.fhhannover.inform.trust.ifmapj.channel.ARC;
import de.fhhannover.inform.trust.ifmapj.channel.SSRC;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapErrorResult;
import de.fhhannover.inform.trust.ifmapj.exception.IfmapException;
import de.fhhannover.inform.trust.ifmapj.exception.InitializationException;
import de.fhhannover.inform.trust.ifmapj.identifier.AccessRequest;
import de.fhhannover.inform.trust.ifmapj.identifier.Identifier;
import de.fhhannover.inform.trust.ifmapj.identifier.Identifiers;
import de.fhhannover.inform.trust.ifmapj.identifier.Identity;
import de.fhhannover.inform.trust.ifmapj.identifier.IdentityType;
import de.fhhannover.inform.trust.ifmapj.identifier.IpAddress;
import de.fhhannover.inform.trust.ifmapj.messages.MetadataLifetime;
import de.fhhannover.inform.trust.ifmapj.messages.PublishDelete;
import de.fhhannover.inform.trust.ifmapj.messages.PublishElement;
import de.fhhannover.inform.trust.ifmapj.messages.PublishNotify;
import de.fhhannover.inform.trust.ifmapj.messages.PublishRequest;
import de.fhhannover.inform.trust.ifmapj.messages.PublishUpdate;
import de.fhhannover.inform.trust.ifmapj.messages.Requests;
import de.fhhannover.inform.trust.ifmapj.messages.SearchRequest;
import de.fhhannover.inform.trust.ifmapj.messages.SearchResult;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeElement;
import de.fhhannover.inform.trust.ifmapj.messages.SubscribeRequest;
import de.fhhannover.inform.trust.ifmapj.metadata.EnforcementAction;
import de.fhhannover.inform.trust.ifmapj.metadata.StandardIfmapMetadataFactory;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class SOAPMessageSender {
    public static final byte PUBLISH_TYPE_UPDATE = 0;
    public static final byte PUBLISH_TYPE_NOTIFY = 1;
    public static byte publishMode = 0;
    final String OTHER_TYPE_DEFINITION = "32939:category";
    final String NAMESPACE = "http://www.esukom.de/2012/ifmap-metadata/1";
    final String NAMESPACE_PREFIX = "esukom";
    final String QUANT = "quantitive";
    final String ARBIT = "arbitrary";
    final String QUALI = "qualified";
    private SSRC mSSRC;
    private volatile boolean mSessionActive;
    private DocumentBuilderFactory mDocumentBuilderFactory = null;
    private DocumentBuilder mDocumentBuilder = null;
    private StandardIfmapMetadataFactory mMetadataFactory;
    private boolean mInitialPublishDone = false;
    private static SOAPMessageSender mInstance;
    private ArrayList<OpenVPNMappingResult> mVpnClientList = new ArrayList();
    private int arCounter = 0;

    private SOAPMessageSender() {
        this.mMetadataFactory = IfmapJ.createStandardMetadataFactory();
        this.mDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.mDocumentBuilder = this.mDocumentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized SOAPMessageSender getInstance() {
        if (mInstance == null) {
            mInstance = new SOAPMessageSender();
        }
        return mInstance;
    }

    public void prepareSSRC() throws InitializationException {
        if (this.mSSRC == null) {
            TrustManager[] tms = IfmapJHelper.getTrustManagers((String)GeneralConfig.MAPSERVER_TRUSTSTORE_PATH, (String)GeneralConfig.MAPSERVER_TRUSTSTORE_PASSWORD);
            if (GeneralConfig.MAPSERVER_BASICAUTH_ENABLED) {
                this.mSSRC = IfmapJ.createSSRC((String)GeneralConfig.MAPSERVER_URL, (String)GeneralConfig.MAPSERVER_BASICAUTH_USER, (String)GeneralConfig.MAPSERVER_BASICAUTH_PASSWORD, (TrustManager[])tms);
            } else {
                KeyManager[] kms = IfmapJHelper.getKeyManagers((String)GeneralConfig.MAPSERVER_KEYSTORE_PATH, (String)GeneralConfig.MAPSERVER_KEYSTORE_PASSWORD);
                this.mSSRC = IfmapJ.createSSRC((String)GeneralConfig.MAPSERVER_URL, (KeyManager[])kms, (TrustManager[])tms);
            }
        }
    }

    public void newSession() throws IfmapErrorResult, IfmapException {
        if (!this.mSessionActive && this.mSSRC != null) {
            this.mSSRC.newSession();
            this.mSessionActive = true;
        }
    }

    public void endSession() throws IfmapErrorResult, IfmapException {
        if (!this.mSessionActive || this.mSSRC == null) {
            return;
        }
        this.mSSRC.endSession();
        this.mSessionActive = false;
    }

    public void purgePublisher() throws IfmapErrorResult, IfmapException {
        if (this.mSSRC != null && this.mSessionActive) {
            this.mSSRC.purgePublisher();
        }
    }

    public String getIfMapPublisherId() {
        if (this.mSSRC != null && this.mSessionActive) {
            return this.mSSRC.getPublisherId();
        }
        return null;
    }

    public ARC getARC() {
        if (this.mSSRC != null) {
            try {
                return this.mSSRC.getArc();
            }
            catch (InitializationException e) {
                IfMapClient.exit("error while initializing ARC");
            }
        }
        return null;
    }

    public void publishEventUpdate(MappingResult[] resultList) {
        PublishRequest pr = Requests.createPublishReq();
        PublishUpdate pu = null;
        PublishNotify pn = null;
        PublishDelete pd = null;
        Document event = null;
        MappingResult[] mappingResultArray = resultList;
        int n = resultList.length;
        int n2 = 0;
        while (n2 < n) {
            IpAddress ipAddress;
            MappingResult mappingResult = mappingResultArray[n2];
            EventMappingResult tmpEvent = (EventMappingResult)mappingResult;
            String name = null;
            if (tmpEvent.getName() != null && tmpEvent.getName().length() > 0) {
                name = tmpEvent.getName();
            } else {
                IfMapClient.LOGGER.warning("no name for current event, using 'undefined'");
                tmpEvent.setName("undefined");
            }
            event = this.mMetadataFactory.createEvent(name, tmpEvent.getDiscoveredTime(), this.getIfMapPublisherId(), Integer.valueOf(tmpEvent.getMagnitude()), Integer.valueOf(tmpEvent.getConfidence()), tmpEvent.getSignificance(), tmpEvent.getEventMessageType(), "", "", tmpEvent.getVulnerabilityUri());
            Identity ident = null;
            if (tmpEvent.getIdentity() != null) {
                ident = Identifiers.createIdentity((IdentityType)IdentityType.aikName, (String)tmpEvent.getIdentity());
            }
            if ((ipAddress = this.createIpAddress(tmpEvent.getIp(), tmpEvent.getIpType())) == null) {
                IfMapClient.LOGGER.warning("error while detecting ip-type from mapping-result, skipping entry");
            } else if (publishMode == 0) {
                pu = Requests.createPublishUpdate();
                pu.setLifeTime(MetadataLifetime.session);
                pu.setIdentifier1((Identifier)ipAddress);
                if (tmpEvent.getIdentity() != null) {
                    pu.setIdentifier2((Identifier)ident);
                }
                pu.addMetadata(event);
                PublishDelete pdNagiosHostState = null;
                PublishDelete pdNagiosServiceState = null;
                String nagiosHostStateMsg = "Detected Host State: ";
                String nagiosServiceStateMsg = "Detected Service State: ";
                if (tmpEvent.getName().startsWith("Detected Host State")) {
                    if (tmpEvent.getName().contains("UP")) {
                        nagiosHostStateMsg = String.valueOf(nagiosHostStateMsg) + "DOWN";
                    } else if (tmpEvent.getName().contains("DOWN")) {
                        nagiosHostStateMsg = String.valueOf(nagiosHostStateMsg) + "UP";
                    }
                    pdNagiosHostState = Requests.createPublishDelete();
                    pdNagiosHostState.setIdentifier1((Identifier)ipAddress);
                    pdNagiosHostState.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
                    pdNagiosHostState.setFilter("meta:event[name='" + nagiosHostStateMsg + "']");
                    pr.addPublishElement((PublishElement)pdNagiosHostState);
                } else if (tmpEvent.getName().startsWith("Detected Service State")) {
                    if (tmpEvent.getName().contains("OK")) {
                        nagiosServiceStateMsg = String.valueOf(nagiosServiceStateMsg) + "CRITICAL";
                    } else if (tmpEvent.getName().contains("CRITICAL")) {
                        nagiosServiceStateMsg = String.valueOf(nagiosServiceStateMsg) + "OK";
                    }
                    pdNagiosServiceState = Requests.createPublishDelete();
                    pdNagiosServiceState.setIdentifier1((Identifier)ipAddress);
                    pdNagiosServiceState.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
                    pdNagiosServiceState.setFilter("meta:event[name='" + nagiosServiceStateMsg + "']");
                    pr.addPublishElement((PublishElement)pdNagiosServiceState);
                }
                pd = Requests.createPublishDelete();
                pd.setIdentifier1((Identifier)ipAddress);
                pd.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
                pd.setFilter("meta:event[name='" + name + "']");
                pr.addPublishElement((PublishElement)pd);
                pr.addPublishElement((PublishElement)pu);
            } else if (publishMode == 1) {
                pn = Requests.createPublishNotify();
                pn.setIdentifier1((Identifier)ipAddress);
                if (tmpEvent.getIdentity() != null) {
                    pn.setIdentifier2((Identifier)ident);
                }
                pn.addMetadata(event);
                pr.addPublishElement((PublishElement)pn);
            }
            ++n2;
        }
        this.publish(pr);
    }

    public void publishEsukomSpecificSnortEventUpdate(MappingResult[] resultList) {
        boolean useSeperateRequests = true;
        PublishRequest publishRequest = Requests.createPublishReq();
        int i = 0;
        while (i < resultList.length) {
            if (useSeperateRequests) {
                publishRequest = Requests.createPublishReq();
            }
            Identity mIDSCategory = this.createCategory("ids", String.valueOf(this.getIfMapPublisherId()) + ":23");
            EventMappingResult tmpEvent = (EventMappingResult)resultList[i];
            String name = null;
            if (tmpEvent.getName() != null && tmpEvent.getName().length() > 0) {
                name = tmpEvent.getName();
            } else {
                name = "undefined";
                tmpEvent.setName(name);
            }
            IpAddress ipAddress = this.createIpAddress(tmpEvent.getIp(), tmpEvent.getIpType());
            if (ipAddress != null) {
                Document eventNameFeature = this.createFeature("ids.EventName", tmpEvent.getDiscoveredTime(), name, "arbitrary");
                Document eventTypeFeature = this.createFeature("ids.EventType", tmpEvent.getDiscoveredTime(), tmpEvent.getEventMessageType().name(), "qualified");
                Document eventConfidenceFeature = this.createFeature("ids.EventConfidence", tmpEvent.getDiscoveredTime(), tmpEvent.getConfidence(), "quantitive");
                Document eventImpactFeature = this.createFeature("ids.EventImpact", tmpEvent.getDiscoveredTime(), tmpEvent.getMagnitude(), "quantitive");
                Document eventThreadFeature = this.createFeature("ids.EventThread", tmpEvent.getDiscoveredTime(), tmpEvent.getSignificance().name(), "qualified");
                Document eventSourceFeature = this.createFeature("ids.EventSource", tmpEvent.getDiscoveredTime(), ipAddress.getValue(), "arbitrary");
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventNameFeature, MetadataLifetime.session, publishMode);
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventTypeFeature, MetadataLifetime.session, publishMode);
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventConfidenceFeature, MetadataLifetime.session, publishMode);
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventImpactFeature, MetadataLifetime.session, publishMode);
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventThreadFeature, MetadataLifetime.session, publishMode);
                this.addToPublishRequest(publishRequest, (Identifier)mIDSCategory, null, eventSourceFeature, MetadataLifetime.session, publishMode);
                if (useSeperateRequests) {
                    this.publish(publishRequest);
                }
            }
            ++i;
        }
        if (!useSeperateRequests) {
            this.publish(publishRequest);
        }
    }

    public void publishSubscription(String ip, int sequenceNumber) {
        IpAddress myIp = Identifiers.createIp4((String)ip);
        SubscribeRequest subsc1 = Requests.createSubscribeReq((SubscribeElement)Requests.createSubscribeUpdate((String)new Integer(sequenceNumber).toString(), null, (Integer)10, null, null, null, (Identifier)myIp));
        try {
            this.mSSRC.subscribe(subsc1);
        }
        catch (IfmapErrorResult e) {
            e.printStackTrace();
        }
        catch (IfmapException e) {
            e.printStackTrace();
        }
    }

    public void publishAlertSubscribtion() {
        Identity myIdentity = Identifiers.createIdentity((IdentityType)IdentityType.other, (String)"alert", null, (String)"32939:category");
        SubscribeRequest subsc1 = Requests.createSubscribeReq((SubscribeElement)Requests.createSubscribeUpdate((String)"1", null, (Integer)10, null, null, null, (Identifier)myIdentity));
        try {
            this.mSSRC.subscribe(subsc1);
        }
        catch (IfmapErrorResult e) {
            e.printStackTrace();
        }
        catch (IfmapException e) {
            e.printStackTrace();
        }
    }

    public SearchResult publishSearchRequest(String ip) {
        IpAddress myIp = Identifiers.createIp4((String)ip);
        SearchRequest sreq1 = Requests.createSearchReq(null, (Integer)8, null, null, null, (Identifier)myIp);
        try {
            SearchResult myResult = this.mSSRC.search(sreq1);
            return myResult;
        }
        catch (IfmapErrorResult e) {
            e.printStackTrace();
        }
        catch (IfmapException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void publishEnforcementReportUpdate(String ip, EnforcementAction enforcementAction, String otherTypeDefinition, String enforcementReason) {
        if (otherTypeDefinition == null) {
            otherTypeDefinition = "";
        }
        if (enforcementReason == null) {
            enforcementReason = "";
        }
        IpAddress myIp = Identifiers.createIp4((String)ip);
        PublishRequest pr = Requests.createPublishReq();
        PublishUpdate pu = null;
        PublishNotify pn = null;
        Document enforcementReport = this.mMetadataFactory.createEnforcementReport(enforcementAction, otherTypeDefinition, enforcementReason);
        if (enforcementReport != null && myIp != null) {
            if (publishMode == 0) {
                pu = Requests.createPublishUpdate();
                pu.setLifeTime(MetadataLifetime.session);
                pu.setIdentifier1((Identifier)myIp);
                pu.addMetadata(enforcementReport);
            } else if (publishMode == 1) {
                pn = Requests.createPublishNotify();
                pn.setIdentifier1((Identifier)myIp);
                pn.addMetadata(enforcementReport);
            }
            pr.addPublishElement((PublishElement)pu);
            this.publish(pr);
        }
    }

    public void publishOpenVpnData(MappingResult[] resultList) {
        IpAddress vpnIp;
        IpAddress ispIp;
        OpenVPNMappingResult currentResult;
        ArrayList<Object> publishClients = new ArrayList<Object>();
        ArrayList deleteClients = new ArrayList();
        boolean deleteAllClients = false;
        if (resultList.length == 1 && (currentResult = (OpenVPNMappingResult)resultList[0]).getIspIpAddress().equals("999.999.999.999")) {
            deleteClients = (ArrayList)this.mVpnClientList.clone();
            this.mVpnClientList.clear();
            deleteAllClients = true;
        }
        if (!deleteAllClients) {
            boolean found;
            int i = 0;
            while (i < resultList.length) {
                OpenVPNMappingResult currentResult2 = (OpenVPNMappingResult)resultList[i];
                String currentClientIp = currentResult2.getIspIpAddress();
                found = false;
                for (OpenVPNMappingResult currentClient : this.mVpnClientList) {
                    String currentExistingIp = currentClient.getIspIpAddress();
                    if (!currentExistingIp.equals(currentClientIp)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    publishClients.add(currentResult2);
                }
                ++i;
            }
            for (OpenVPNMappingResult currentClient : this.mVpnClientList) {
                String currentExistingClientIp = currentClient.getIspIpAddress();
                found = false;
                int i2 = 0;
                while (i2 < resultList.length) {
                    OpenVPNMappingResult currentResult3 = (OpenVPNMappingResult)resultList[i2];
                    String currentClientIp = currentResult3.getIspIpAddress();
                    if (currentClientIp.equals(currentExistingClientIp)) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (found) continue;
                deleteClients.add(currentClient);
            }
        }
        PublishRequest pr = Requests.createPublishReq();
        PublishDelete pd1 = null;
        PublishDelete pd2 = null;
        PublishDelete pd3 = null;
        PublishUpdate pu = null;
        PublishUpdate pu2 = null;
        PublishUpdate pu3 = null;
        for (OpenVPNMappingResult openVPNMappingResult : deleteClients) {
            ispIp = Identifiers.createIp4((String)openVPNMappingResult.getIspIpAddress());
            vpnIp = Identifiers.createIp4((String)openVPNMappingResult.getVpnIPAddress());
            Identity ident = Identifiers.createIdentity((IdentityType)IdentityType.userName, (String)openVPNMappingResult.getUsername());
            AccessRequest ar = Identifiers.createAr((String)(String.valueOf(this.getIfMapPublisherId()) + ":" + openVPNMappingResult.getArCounter()));
            pd1 = Requests.createPublishDelete((Identifier)ar, (Identifier)ident);
            pd1.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
            pd2 = Requests.createPublishDelete((Identifier)ar, (Identifier)ispIp);
            pd2.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
            pd3 = Requests.createPublishDelete((Identifier)ar, (Identifier)vpnIp);
            pd3.addNamespaceDeclaration("meta", "http://www.trustedcomputinggroup.org/2010/IFMAP-METADATA/2");
            pr.addPublishElement((PublishElement)pd1);
            pr.addPublishElement((PublishElement)pd2);
            pr.addPublishElement((PublishElement)pd3);
            this.mVpnClientList.remove(openVPNMappingResult);
        }
        for (OpenVPNMappingResult openVPNMappingResult : publishClients) {
            openVPNMappingResult.setArCounter(this.arCounter);
            this.mVpnClientList.add(openVPNMappingResult);
            ispIp = Identifiers.createIp4((String)openVPNMappingResult.getIspIpAddress());
            vpnIp = Identifiers.createIp4((String)openVPNMappingResult.getVpnIPAddress());
            AccessRequest myAr = Identifiers.createAr((String)(String.valueOf(this.getIfMapPublisherId()) + ":" + this.arCounter++));
            Identity myIdentity = Identifiers.createIdentity((IdentityType)IdentityType.userName, (String)openVPNMappingResult.getUsername());
            pu = Requests.createPublishUpdate();
            pu.setLifeTime(MetadataLifetime.session);
            pu.setIdentifier1((Identifier)myIdentity);
            pu.setIdentifier2((Identifier)myAr);
            pu.addMetadata(this.mMetadataFactory.createAuthAs());
            pu2 = Requests.createPublishUpdate();
            pu2.setLifeTime(MetadataLifetime.session);
            pu2.setIdentifier1((Identifier)ispIp);
            pu2.setIdentifier2((Identifier)myAr);
            pu2.addMetadata(this.mMetadataFactory.createArIp());
            pu2 = Requests.createPublishUpdate();
            pu2.setLifeTime(MetadataLifetime.session);
            pu2.setIdentifier1((Identifier)ispIp);
            pu2.setIdentifier2((Identifier)myAr);
            pu2.addMetadata(this.mMetadataFactory.createArIp());
            pu3 = Requests.createPublishUpdate();
            pu3.setLifeTime(MetadataLifetime.session);
            pu3.setIdentifier1((Identifier)vpnIp);
            pu3.setIdentifier2((Identifier)myAr);
            pu3.addMetadata(this.mMetadataFactory.createArIp());
            pr.addPublishElement((PublishElement)pu);
            pr.addPublishElement((PublishElement)pu2);
            pr.addPublishElement((PublishElement)pu3);
        }
        if (pr != null && pr.getPublishElements() != null && pr.getPublishElements().size() > 0) {
            this.publish(pr);
        }
    }

    private void publish(PublishRequest pr) {
        try {
            this.mSSRC.publish(pr);
            if (!this.mInitialPublishDone) {
                this.mInitialPublishDone = true;
            }
        }
        catch (IfmapErrorResult e) {
            e.printStackTrace();
            IfMapClient.exit("ifmap-error-result while publishing data over ssrc:");
        }
        catch (IfmapException e) {
            e.printStackTrace();
            IfMapClient.exit("ifmap-error-exception while publishing data over ssrc:");
        }
    }

    private Identity createCategory(String name, String admDomain) {
        return Identifiers.createIdentity((IdentityType)IdentityType.other, (String)name, (String)admDomain, (String)"32939:category");
    }

    public void addToPublishRequest(PublishRequest request, Identifier ident1, Identifier ident2, Document metadata, MetadataLifetime metadataLifeTime, byte publishType) {
        if (publishType == 0) {
            PublishUpdate publishUpdate = Requests.createPublishUpdate();
            publishUpdate.setIdentifier1(ident1);
            if (ident2 != null) {
                publishUpdate.setIdentifier2(ident2);
            }
            publishUpdate.addMetadata(metadata);
            publishUpdate.setLifeTime(metadataLifeTime);
            if (this.mInitialPublishDone) {
                PublishDelete publishDelete = Requests.createPublishDelete();
                if (metadata.getElementsByTagName("id").item(0) != null) {
                    publishDelete.addNamespaceDeclaration("esukom", "http://www.esukom.de/2012/ifmap-metadata/1");
                    publishDelete.setFilter(String.valueOf(metadata.getChildNodes().item(0).getPrefix()) + ":" + metadata.getChildNodes().item(0).getLocalName() + "[" + "id='" + metadata.getElementsByTagName("id").item(0).getTextContent() + "'" + " and " + "@ifmap-publisher-id='" + this.mSSRC.getPublisherId() + "']");
                }
                publishDelete.setIdentifier1(ident1);
                if (ident2 != null) {
                    publishDelete.setIdentifier2(ident2);
                }
                request.addPublishElement((PublishElement)publishDelete);
            }
            request.addPublishElement((PublishElement)publishUpdate);
        } else if (publishType == 1) {
            PublishNotify publishNotify = Requests.createPublishNotify();
            publishNotify.setIdentifier1(ident1);
            if (ident2 != null) {
                publishNotify.setIdentifier2(ident2);
            }
            publishNotify.addMetadata(metadata);
            request.addPublishElement((PublishElement)publishNotify);
        }
    }

    private Document createFeature(String id, String timestamp, String value, String contentType) {
        Document doc = this.mDocumentBuilder.newDocument();
        Element feature = doc.createElementNS("http://www.esukom.de/2012/ifmap-metadata/1", "esukom:feature");
        feature.setAttributeNS(null, "ifmap-cardinality", "multiValue");
        feature.setAttribute("ctxp-timestamp", timestamp);
        Element idElement = doc.createElement("id");
        idElement.setTextContent(id);
        feature.appendChild(idElement);
        Element typeElement = doc.createElement("type");
        typeElement.setTextContent(contentType);
        feature.appendChild(typeElement);
        Element valueElement = doc.createElement("value");
        valueElement.setTextContent(value);
        feature.appendChild(valueElement);
        doc.appendChild(feature);
        return doc;
    }

    private IpAddress createIpAddress(String address, String type) {
        IpAddress ipAddress = null;
        if (type.startsWith("IPv4")) {
            ipAddress = Identifiers.createIp4((String)address);
        } else if (type.startsWith("IPv6")) {
            ipAddress = Identifiers.createIp6((String)address);
        }
        return ipAddress;
    }
}

