/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads.file;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class FilePollingThread
extends PollingThread {
    protected boolean performPreLogFileExistsCheck = false;
    protected boolean logFound = false;
    protected String filePath;
    protected File file;
    protected boolean isFirstStart = false;
    protected int lastEntryLineNumber = 0;
    protected long lastModified;
    protected boolean useLogRotate;
    protected String logRotatePattern;

    public boolean isLogRotateActive() {
        return this.useLogRotate;
    }

    @Override
    protected void initProperties(Properties props) {
        this.isFirstStart = true;
        this.filePath = props.getProperty("filepath", null);
        if (Toolbox.isNullOrEmpty(this.filePath)) {
            IfMapClient.exit("file path null or empty");
        }
        this.useLogRotate = Boolean.valueOf(props.getProperty("logrotate", "false"));
        if (this.useLogRotate) {
            this.logRotatePattern = props.getProperty("rotatepattern", "");
            this.filePath = this.filePath.replace("$", Toolbox.getNowDateAsString(this.logRotatePattern));
        }
        this.performPreLogFileExistsCheck = Boolean.valueOf(props.getProperty("precheck", "true"));
        if (this.performPreLogFileExistsCheck) {
            IfMapClient.LOGGER.config("opening file at path: [" + this.filePath + "]");
            if (new File(this.filePath).exists()) {
                this.file = new File(this.filePath);
                this.performPreLogFileExistsCheck = false;
            } else {
                IfMapClient.exit("log-file at [" + this.filePath + "] could not be found");
            }
            this.lastModified = this.file.lastModified();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.pausing) continue;
            try {
                if (!this.performPreLogFileExistsCheck && !this.logFound) {
                    if (new File(this.filePath).exists()) {
                        this.file = new File(this.filePath);
                        this.lastModified = this.file.lastModified();
                        this.logFound = true;
                    } else {
                        Thread.sleep(this.sleepTime);
                    }
                }
                if (!this.logFound) continue;
                long actualLastModified = this.file.lastModified();
                IfMapClient.LOGGER.info("checking file  [" + this.filePath + "] for updates");
                if (this.isFirstStart | this.lastModified != actualLastModified) {
                    this.lastModified = actualLastModified;
                    IfMapClient.LOGGER.info("file has been updated, looking for new entries");
                    this.notify(this.readFile());
                } else {
                    IfMapClient.LOGGER.info("file has not been updated");
                }
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("error while checking file [" + this.filePath + "] for updates");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ArrayList resultList = (ArrayList)o;
            if (resultList.size() > 0) {
                this.pausing = true;
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries found in file [" + this.filePath + "]");
            }
        } else {
            IfMapClient.LOGGER.info("file [" + this.filePath + "] is null, not calling observer");
        }
    }

    protected abstract ArrayList<HashMap<String, String>> readFile();
}

