/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads.file;

import de.esukom.decoit.ifmapclient.config.GeneralConfig;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.file.FilePollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;

public class IPTablesULogFilePollingThread
extends FilePollingThread {
    private String[] mIpBlacklist;
    private boolean mLogSkippedEntries;

    public IPTablesULogFilePollingThread(Properties pr) {
        this.initProperties(pr);
    }

    @Override
    protected void initProperties(Properties props) {
        super.initProperties(props);
        this.mIpBlacklist = props.getProperty("iptables.iplist.blacklist").split(",");
        IfMapClient.LOGGER.config("reading in ip-blacklist from enforcement.properties");
        if (this.mIpBlacklist == null || this.mIpBlacklist.length < 1) {
            IfMapClient.LOGGER.config("no ip-addresses defined in blacklist");
        }
        int i = 0;
        while (i < this.mIpBlacklist.length) {
            IfMapClient.LOGGER.config("entry [" + i + "] on blacklist: " + this.mIpBlacklist[i]);
            ++i;
        }
        this.mLogSkippedEntries = Toolbox.getBoolPropertyWithDefault("iptables.log.skippedentries", false, props);
    }

    @Override
    protected ArrayList<HashMap<String, String>> readFile() {
        int currentLineInSingleEntry = 0;
        int currentCycleLineNumber = 0;
        BufferedReader input = null;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> tempEventData = new HashMap<String, String>();
        try {
            try {
                input = new BufferedReader(new FileReader(this.file), 1);
                String line = null;
                String entryDate = null;
                boolean skipCurrentEntry = false;
                while ((line = input.readLine()) != null) {
                    if (this.isFirstStart) {
                        ++this.lastEntryLineNumber;
                    }
                    if (!(this.isFirstStart | ++currentCycleLineNumber > this.lastEntryLineNumber)) continue;
                    if (!skipCurrentEntry) {
                        if (!tempEventData.isEmpty()) {
                            result.add((HashMap)tempEventData.clone());
                        }
                    } else {
                        skipCurrentEntry = false;
                    }
                    tempEventData.clear();
                    currentLineInSingleEntry = 0;
                    Matcher ip4Matcher = Toolbox.getRegExPattern("regex.ip4").matcher(line);
                    if (ip4Matcher.find()) {
                        if (this.inBlacklist(ip4Matcher.group())) {
                            skipCurrentEntry = true;
                            if (this.mLogSkippedEntries) {
                                IfMapClient.LOGGER.warning("entry is inside ip-blacklist [" + ip4Matcher.group() + "]...skipping");
                            }
                        }
                    } else {
                        skipCurrentEntry = true;
                        IfMapClient.LOGGER.warning("could not find IP4-address in current entry...skipping");
                    }
                    if (skipCurrentEntry) continue;
                    Matcher timestampMatcher = Toolbox.getRegExPattern("regex.ulogtimestamp").matcher(line);
                    if (timestampMatcher.find()) {
                        String newLine;
                        entryDate = this.rearrangeDate(String.valueOf(Toolbox.getNowDateAsString("yyyy")) + "/" + timestampMatcher.group());
                        line = newLine = line.replaceFirst(Toolbox.getRegExPattern("regex.ulogtimestamp").toString(), entryDate);
                    } else {
                        skipCurrentEntry = true;
                        IfMapClient.LOGGER.warning("could not find timestamp in current entry...will now skip this entry");
                    }
                    if (!GeneralConfig.MESSAGING_SENDOLD) {
                        if (!Toolbox.getCalendarFromString(entryDate, "yyyy-MM-dd HH:mm:ss", null).after(Toolbox.getCalendarFromString(Toolbox.sClientStartTime, "yyyy-MM-dd HH:mm:ss", null))) continue;
                        tempEventData.put(new Integer(currentLineInSingleEntry).toString(), line);
                        ++currentLineInSingleEntry;
                        continue;
                    }
                    tempEventData.put(new Integer(currentLineInSingleEntry).toString(), line);
                }
                if (!tempEventData.isEmpty() & !skipCurrentEntry) {
                    result.add(tempEventData);
                }
                if (!this.isFirstStart) {
                    this.lastEntryLineNumber = currentCycleLineNumber;
                } else {
                    this.isFirstStart = false;
                }
            }
            catch (FileNotFoundException ex) {
                IfMapClient.exit("could not find ip-tables ulog-file.");
                try {
                    input.close();
                }
                catch (IOException e) {
                    IfMapClient.exit("error while closing input buffer");
                }
            }
            catch (IOException ex) {
                IfMapClient.exit("I/O error while reading iptables ulog-file");
                try {
                    input.close();
                }
                catch (IOException e) {
                    IfMapClient.exit("error while closing input buffer");
                }
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                IfMapClient.exit("error while closing input buffer");
            }
        }
        return result;
    }

    private String rearrangeDate(String currentDate) {
        String[] date = new String[]{currentDate.substring(0, 4), Toolbox.getAplhaNumericMonthMap().get(currentDate.substring(5, 8)), currentDate.substring(9, 11)};
        if (date[2].startsWith(" ")) {
            date[2] = date[2].replaceFirst(" ", "0");
        }
        String timestamp = currentDate.substring(12, currentDate.length());
        return String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + " " + timestamp;
    }

    private boolean inBlacklist(String ip) {
        int i = 0;
        while (i < this.mIpBlacklist.length) {
            if (this.mIpBlacklist[i].equals(ip)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

