/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads.file;

import de.esukom.decoit.ifmapclient.logging.Logging;
import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.file.FilePollingThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class RadiusFilePollingThread
extends FilePollingThread {
    private static boolean sIsFirstStart = true;
    private static boolean sIsFirstStartDetail = true;
    private int mLastEntryLineNumber = 0;
    private int mLastEntryLineNumberDetail = 0;
    private Logger mLogger;
    private String mRadiusLogPath;
    private String mRadiusLogDetailPath;
    private File mFile;
    private SimpleDateFormat mDateFormat = new SimpleDateFormat("yyyyMMdd");
    private long mLastReadedEntry;
    private long mLastModified;
    private long mLastModifiedDetail;
    private HashMap<String, String> mLastEntryHashMap = new HashMap();
    private boolean notLogged = true;

    public RadiusFilePollingThread(Properties pr) {
        this.mLogger = Logging.getTheLogger();
        this.initProperties(pr);
        this.mLogger.info("opening radiusd-log file at path: " + this.mRadiusLogPath);
        if (new File(this.mRadiusLogPath).exists()) {
            this.mFile = new File(this.mRadiusLogPath);
            this.mLastModified = this.mFile.lastModified();
        } else {
            this.mLogger.warning("radiusd-log-file at: " + this.mRadiusLogPath + " doesnt exist!");
        }
        if (new File(this.mRadiusLogDetailPath).exists()) {
            this.mLastModifiedDetail = this.getLatestModifiedDate();
        }
    }

    @Override
    protected void initProperties(Properties props) {
        Date date = new Date();
        sIsFirstStart = true;
        this.mRadiusLogPath = props.getProperty("radius.log.path", null);
        if (this.mRadiusLogPath == null || this.mRadiusLogPath.length() == 0) {
            IfMapClient.exit("error while initializing RADIUSFilePolling Thread: property RADIUS_LOG_PATH cannot be null or empty!");
        }
        this.mRadiusLogPath = String.valueOf(this.mRadiusLogPath) + this.mDateFormat.format(date) + ".log";
        this.mRadiusLogDetailPath = props.getProperty("radius.log.accpath", null);
        if (this.mRadiusLogDetailPath == null || this.mRadiusLogDetailPath.length() == 0) {
            IfMapClient.exit("error while initializing RADIUSFilePolling Thread: property RADIUS_LOG_PATH cannot be null or empty!");
        }
    }

    @Override
    protected ArrayList<HashMap<String, String>> readFile() {
        int currentCycleLineNumber = 0;
        int newEntryNumber = 1;
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> tempEventData = new HashMap<String, String>();
        BufferedReader logReader = null;
        String line = null;
        try {
            logReader = new BufferedReader(new FileReader(this.mFile), 1);
            while ((line = logReader.readLine()) != null) {
                if (sIsFirstStart) {
                    ++this.mLastEntryLineNumber;
                }
                ++currentCycleLineNumber;
                if (sIsFirstStart) {
                    System.out.println(String.valueOf(currentCycleLineNumber) + " " + line);
                    tempEventData.put(String.valueOf(newEntryNumber), line);
                    ++newEntryNumber;
                } else if (currentCycleLineNumber > this.mLastEntryLineNumber) {
                    System.out.println(String.valueOf(currentCycleLineNumber) + " " + line);
                    tempEventData.put(String.valueOf(newEntryNumber), line);
                    ++newEntryNumber;
                }
                if (!sIsFirstStart) continue;
                sIsFirstStart = false;
            }
            this.mLastEntryLineNumber = currentCycleLineNumber;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        ArrayList<String> newestFiles = this.getLatestModified();
        int i = 0;
        while (i < newestFiles.size()) {
            if (!this.mLastEntryHashMap.containsKey(newestFiles.get(i))) {
                this.mLastEntryHashMap.put(newestFiles.get(i), "0");
            }
            ++i;
        }
        int currentCycleLineNumberDetail = 0;
        int i2 = 0;
        while (i2 < newestFiles.size()) {
            currentCycleLineNumberDetail = 0;
            this.mLastEntryLineNumberDetail = this.mLastEntryHashMap.get(newestFiles.get(i2)).equalsIgnoreCase("0") ? 0 : Integer.valueOf(this.mLastEntryHashMap.get(newestFiles.get(i2)));
            try {
                logReader = new BufferedReader(new FileReader(newestFiles.get(i2)), 1);
                String[] resultDetail = this.parseDetialInSingleLine(logReader);
                int j = 0;
                while (j < resultDetail.length) {
                    if (sIsFirstStartDetail) {
                        ++this.mLastEntryLineNumberDetail;
                    }
                    ++currentCycleLineNumberDetail;
                    if (sIsFirstStartDetail) {
                        tempEventData.put(String.valueOf(newEntryNumber), resultDetail[j]);
                        System.out.println(String.valueOf(currentCycleLineNumberDetail) + " " + resultDetail[j]);
                        ++newEntryNumber;
                    } else if (currentCycleLineNumberDetail > this.mLastEntryLineNumberDetail) {
                        System.out.println(String.valueOf(currentCycleLineNumberDetail) + " " + resultDetail[j]);
                        tempEventData.put(String.valueOf(newEntryNumber), resultDetail[j]);
                        ++newEntryNumber;
                    }
                    if (sIsFirstStartDetail) {
                        sIsFirstStartDetail = false;
                    }
                    ++j;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            this.mLastEntryHashMap.remove(newestFiles.get(i2));
            this.mLastEntryHashMap.put(newestFiles.get(i2), String.valueOf(currentCycleLineNumberDetail));
            this.mLastModifiedDetail = this.getLatestModifiedDate();
            ++i2;
        }
        result.add(tempEventData);
        return result;
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ArrayList resultList = (ArrayList)o;
            if (resultList.size() > 0) {
                this.pausing = true;
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                this.mLogger.info("no new entries in radius-logfile, not calling observer");
            }
        } else {
            this.mLogger.warning("retrieved radius-logfile result is null, not calling observer");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            if (!(!this.pausing & this.mFile != null)) continue;
            try {
                long actualLastModified = this.mFile.lastModified();
                this.mLogger.info("checking radius-logfile for updates");
                if (sIsFirstStart | this.mLastModified != actualLastModified) {
                    this.mLastModified = actualLastModified;
                    this.mLogger.info("reading new entries found inside radius-logfile");
                    this.notify(this.readFile());
                    this.notLogged = false;
                } else {
                    this.mLogger.info("no updates in radius-logfile");
                    this.notLogged = true;
                }
                if (this.mLastModifiedDetail != this.getLatestModifiedDate() && this.notLogged) {
                    this.mLogger.info("reading new entries found inside radius-logfile");
                    this.notify(this.readFile());
                } else {
                    this.mLogger.info("no updates in radius-detail-logfile");
                }
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("error while polling log file!");
            }
        }
    }

    public String[] parseDetialInSingleLine(BufferedReader msg) throws IOException {
        String line = null;
        String temp = "";
        ArrayList<String> tempArray = new ArrayList<String>();
        int bla = 1;
        boolean userFound = false;
        while ((line = msg.readLine()) != null) {
            if (!line.equalsIgnoreCase("")) {
                if (line.contains("User-Name") & !userFound) {
                    temp = String.valueOf(temp) + line + ",";
                    userFound = true;
                    continue;
                }
                temp = String.valueOf(temp) + line;
                continue;
            }
            if (temp == null) continue;
            tempArray.add(temp);
            temp = "";
            ++bla;
            userFound = false;
        }
        String[] result = new String[tempArray.size()];
        int i = 0;
        while (i < tempArray.size()) {
            result[i] = (String)tempArray.get(i);
            ++i;
        }
        return result;
    }

    private ArrayList<String> getLatestModified() {
        ArrayList<String> ipFolderList = this.getRaddactContentFolders();
        ArrayList<String> newestFilesPath = new ArrayList<String>();
        int i = 0;
        while (i < ipFolderList.size()) {
            System.out.println("Search in " + ipFolderList.get(i));
            File ipFolder = new File(ipFolderList.get(i));
            File[] content = ipFolder.listFiles();
            ArrayList<Long> dates = new ArrayList<Long>();
            int j = 0;
            while (j < content.length) {
                if (content[j].getName().startsWith("detail-")) {
                    dates.add(content[j].lastModified());
                }
                ++j;
            }
            Collections.sort(dates);
            j = 0;
            while (j < content.length) {
                if (content[j].getName().startsWith("detail-") && content[j].lastModified() == ((Long)dates.get(dates.size() - 1)).longValue()) {
                    newestFilesPath.add(content[j].getAbsolutePath());
                }
                ++j;
            }
            ++i;
        }
        return newestFilesPath;
    }

    private long getLatestModifiedDate() {
        ArrayList<String> ipFolderList = this.getRaddactContentFolders();
        long newestFileDate = 0L;
        ArrayList<Long> dates = new ArrayList<Long>();
        int i = 0;
        while (i < ipFolderList.size()) {
            File ipFolder = new File(ipFolderList.get(i));
            File[] content = ipFolder.listFiles();
            int j = 0;
            while (j < content.length) {
                if (content[j].getName().startsWith("detail-")) {
                    dates.add(content[j].lastModified());
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(dates);
        newestFileDate = (Long)dates.get(dates.size() - 1);
        return newestFileDate;
    }

    private ArrayList<String> getRaddactContentFolders() {
        ArrayList<String> ipFolderList = new ArrayList<String>();
        File radacctFolder = new File(this.mRadiusLogDetailPath);
        if (radacctFolder.exists()) {
            File[] ipFolders = radacctFolder.listFiles();
            int i = 0;
            while (i < ipFolders.length) {
                ipFolderList.add(ipFolders[i].getAbsolutePath());
                ++i;
            }
        }
        return ipFolderList;
    }
}

