/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads.socket;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class SocketPollingThread
extends PollingThread {
    protected int mPort;
    protected ServerSocket mProviderSocket;
    protected Socket mConnection = null;
    protected BufferedReader mBufferReader = null;
    protected DataInputStream mIn = null;

    @Override
    protected void initProperties(Properties props) {
        this.mPort = new Integer(props.getProperty("server.port", "0"));
        IfMapClient.LOGGER.config("initalizing socket on port: " + this.mPort);
        try {
            this.mProviderSocket = new ServerSocket(this.mPort);
        }
        catch (IOException e) {
            IfMapClient.exit("I/O error while creating server socket");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        while (this.running) {
            block18: {
                block17: {
                    if (this.pausing) continue;
                    this.mConnection = this.mProviderSocket.accept();
                    this.mIn = new DataInputStream(this.mConnection.getInputStream());
                    this.mBufferReader = new BufferedReader(new InputStreamReader(this.mIn));
                    String inputLine = "";
                    inputLine = this.mBufferReader.readLine();
                    if (Toolbox.isNullOrEmpty(inputLine)) break block17;
                    IfMapClient.LOGGER.info("socket polling-thread received message: " + inputLine + " from " + this.mConnection.getInetAddress().getHostName());
                    this.notify(this.parseLine(inputLine));
                    break block18;
                }
                try {
                    this.mIn.close();
                }
                catch (IOException ioException) {
                    IfMapClient.exit("error while closing streams and socket");
                }
                break;
                {
                    catch (IOException e) {
                        try {
                            try {
                                IfMapClient.exit("I/O error while reading from socket");
                            }
                            catch (IOException ioException) {
                                IfMapClient.exit("error while building in/output-streams");
                                try {
                                    this.mIn.close();
                                }
                                catch (IOException ioException2) {
                                    IfMapClient.exit("error while closing streams and socket");
                                }
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                this.mIn.close();
                            }
                            catch (IOException ioException) {
                                IfMapClient.exit("error while closing streams and socket");
                            }
                            throw throwable;
                        }
                    }
                }
            }
            try {
                this.mIn.close();
            }
            catch (IOException ioException) {
                IfMapClient.exit("error while closing streams and socket");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ArrayList<HashMap> resultList = new ArrayList<HashMap>();
            resultList.add((HashMap)o);
            if (resultList.size() > 0) {
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no updates received over socket, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.warning("retrieved message from socket is empty, not calling observer");
        }
    }

    protected abstract HashMap<String, String> parseLine(String var1);
}

