/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.pollingthreads.sql;

import de.esukom.decoit.ifmapclient.main.IfMapClient;
import de.esukom.decoit.ifmapclient.pollingthreads.PollingThread;
import de.esukom.decoit.ifmapclient.util.Toolbox;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public abstract class SqlPollingThread
extends PollingThread {
    protected String dbName;
    protected String dbHost;
    protected String dbUser;
    protected String dbPass;
    protected Connection connection = null;
    protected PreparedStatement prepStatement = null;
    protected String rawQuery;
    protected int lastCid = 0;
    protected String idColumnName;
    protected int prepStatIdParamIndex;

    @Override
    protected void initProperties(Properties props) {
        this.dbHost = props.getProperty("database.host", null);
        this.dbName = props.getProperty("database.name", null);
        this.dbUser = props.getProperty("database.user", null);
        this.dbPass = props.getProperty("database.pass", null);
        this.idColumnName = props.getProperty("database.idcolumn", null);
        this.prepStatIdParamIndex = Integer.valueOf(props.getProperty("database.statementparameterindex", "0"));
        if (Toolbox.isNullOrEmpty(this.dbHost)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.host not found");
        } else if (Toolbox.isNullOrEmpty(this.dbName)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.name not found");
        } else if (Toolbox.isNullOrEmpty(this.dbUser)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.user not found");
        } else if (Toolbox.isNullOrEmpty(this.dbPass)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.pass not found");
        } else if (Toolbox.isNullOrEmpty(this.idColumnName)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.idcolumn not found");
        } else if (this.prepStatIdParamIndex == 0) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - statementparameterindex not found");
        }
        this.rawQuery = props.getProperty("database.query", null);
        if (Toolbox.isNullOrEmpty(this.rawQuery)) {
            IfMapClient.exit("error while initializing SQL-Polling Thread - property database.query not found");
        }
        this.initDatabaseConnection(this.dbHost, this.dbName, this.dbUser, this.dbPass);
        try {
            this.prepStatement = this.connection.prepareStatement(this.rawQuery);
        }
        catch (SQLException e) {
            IfMapClient.exit("SQL-Polling Thread encountered an error while building prepared statement");
        }
    }

    private void initDatabaseConnection(String host, String name, String user, String pass) {
        IfMapClient.LOGGER.config("starting connection with host:" + host + " name:" + name + " user:" + user);
        try {
            Class.forName("com.mysql.jdbc.Driver");
            this.connection = DriverManager.getConnection("jdbc:mysql://" + host + "/" + name, user, pass);
        }
        catch (Exception e) {
            IfMapClient.exit("could not connect to database");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            if (this.pausing) continue;
            try {
                IfMapClient.LOGGER.info("checking " + this.dbName + " database for updates...");
                this.connection.setAutoCommit(false);
                this.prepStatement.setInt(this.prepStatIdParamIndex, this.lastCid);
                ResultSet resultSet = this.prepStatement.executeQuery();
                this.connection.commit();
                this.notify(resultSet);
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    IfMapClient.exit("sql-polling-thread encountered an error");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                IfMapClient.exit("sql-polling-thread encountered an error while executing query");
            }
        }
    }

    @Override
    public void notify(Object o) {
        if (o != null) {
            ResultSet result = (ResultSet)o;
            ArrayList<HashMap<String, String>> resultList = this.getResultList(result);
            if (resultList != null && resultList.size() > 0) {
                this.pausing = true;
                this.lastCid = new Integer(resultList.get(resultList.size() - 1).get(this.idColumnName));
                this.setChanged();
                this.notifyObservers(resultList);
            } else {
                IfMapClient.LOGGER.info("no new entries in database, not calling observer");
            }
        } else {
            IfMapClient.LOGGER.warning("retrieved database result is null, not calling observer");
        }
    }

    protected abstract ArrayList<HashMap<String, String>> getResultList(ResultSet var1);
}

