/*
 * Decompiled with CFR 0.152.
 */
package de.esukom.decoit.ifmapclient.util;

import de.esukom.decoit.ifmapclient.logging.Logging;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Toolbox {
    public static Logger sLogger = Logging.getTheLogger();
    public static final String sClientStartTime = Toolbox.getNowDateAsString("yyyy-MM-dd HH:mm:ss");
    public static HashMap<String, Pattern> regExMap = new HashMap();
    public static HashMap<String, String> MonthValues = new HashMap();

    public static void loadAndPrepareRegExFromFile(Properties pr) {
        Enumeration<Object> em = pr.keys();
        while (em.hasMoreElements()) {
            String str = (String)em.nextElement();
            if (Toolbox.isNullOrEmpty(str) || Toolbox.isNullOrEmpty(pr.get(str).toString()) || !str.startsWith("regex")) continue;
            regExMap.put(str, Pattern.compile(pr.get(str).toString()));
        }
    }

    public static Pattern getRegExPattern(String key) {
        if (regExMap == null) {
            return null;
        }
        return regExMap.get(key);
    }

    public static String getStringProperty(String property, Properties conf, boolean checkIfFileExists) {
        String propertyValue = conf.getProperty(property, null);
        if (Toolbox.isNullOrEmpty(propertyValue)) {
            sLogger.warning("required property <" + property + "> is empty");
            return null;
        }
        if (checkIfFileExists) {
            if (new File(propertyValue).exists()) {
                sLogger.info("value for property <" + property + "> is: " + propertyValue);
                return propertyValue;
            }
            sLogger.warning("file for property  <" + property + "> at path " + propertyValue + " doesnt exists");
            return null;
        }
        sLogger.info("value for property <" + property + "> is: " + propertyValue);
        return propertyValue;
    }

    public static String getStringPropertyWithDefault(String property, Properties conf, String defaultValue) {
        String propertyValue = conf.getProperty(property, null);
        if (Toolbox.isNullOrEmpty(propertyValue)) {
            sLogger.warning("required property <" + property + "> not found...using default (" + defaultValue + ")");
            return defaultValue;
        }
        sLogger.info("value for property <" + property + "> is: " + propertyValue);
        return propertyValue;
    }

    public static int getIntPropertyWithDefault(String property, int defaultValue, Properties conf, boolean withoutZero) {
        int returnValue;
        String propertyValue = conf.getProperty(property, null);
        if (Toolbox.isNullOrEmpty(propertyValue)) {
            sLogger.warning("<" + property + "> is empty or null...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        if (withoutZero && propertyValue.equals("0")) {
            sLogger.warning("<" + property + "> cannot be zero...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        try {
            returnValue = Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            sLogger.warning("<" + property + "> must be an integer...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        sLogger.info("value for <" + property + "> is: " + returnValue);
        return returnValue;
    }

    public static boolean getBoolPropertyWithDefault(String property, boolean defaultValue, Properties conf) {
        String propertyValue = conf.getProperty(property, null);
        if (Toolbox.isNullOrEmpty(propertyValue)) {
            sLogger.warning("<" + property + "> is empty or null...using default value (" + defaultValue + ")");
            return defaultValue;
        }
        boolean returnValue = Boolean.parseBoolean(propertyValue);
        sLogger.info("value for property <" + property + "> is: " + returnValue);
        return returnValue;
    }

    public static boolean checkConfig(String[] propArray) {
        return propArray == null || propArray.length <= 0 || propArray[0].length() != 0;
    }

    public static String getNowDateAsString(String dateFormat) {
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentDate.getTime());
    }

    public static Date getNowDate(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        Date date = null;
        try {
            date = sdf.parse(Toolbox.getNowDateAsString(dateFormat));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Calendar getCalendarFromString(String dateString, String dateFormat, Locale loc) {
        Date date = null;
        SimpleDateFormat formatter = loc == null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat(dateFormat, loc);
        try {
            date = formatter.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String convertTimestampToIfMapFormat(String dateString, String dateSplitter, String dateTimeSplitter) {
        String[] timestamp = dateString.split(dateTimeSplitter);
        String[] date = timestamp[0].split(dateSplitter);
        return String.valueOf(date[0]) + "-" + date[1] + "-" + date[2] + "T" + timestamp[1] + "Z";
    }

    public static HashMap<String, String> getAplhaNumericMonthMap() {
        if (MonthValues.isEmpty()) {
            MonthValues.put("Jan", "01");
            MonthValues.put("Feb", "02");
            MonthValues.put("Mar", "03");
            MonthValues.put("Apr", "04");
            MonthValues.put("May", "05");
            MonthValues.put("Jun", "06");
            MonthValues.put("Jul", "07");
            MonthValues.put("Aug", "08");
            MonthValues.put("Sep", "09");
            MonthValues.put("Oct", "10");
            MonthValues.put("Nov", "11");
            MonthValues.put("Dec", "12");
        }
        return MonthValues;
    }

    public static boolean isNullOrEmpty(String test) {
        if (test == null) {
            return true;
        }
        return test.trim().isEmpty();
    }

    public static String convertIP6AddressToIFMAPIP6AddressPattern(String adr) {
        String[] singleEntrys = adr.split(":");
        String convertedAddress = new String();
        int i = 0;
        while (i < singleEntrys.length) {
            singleEntrys[i] = singleEntrys[i].replaceFirst("0*", "");
            if (singleEntrys[i].length() < 1) {
                singleEntrys[i] = "0";
            }
            if (i != singleEntrys.length - 1) {
                int n = i;
                singleEntrys[n] = String.valueOf(singleEntrys[n]) + ":";
            }
            convertedAddress = String.valueOf(convertedAddress) + singleEntrys[i];
            ++i;
        }
        return convertedAddress;
    }
}

